#!/bin/sh
backup=$HOME/ab_clean_backup.$$
in_ab=$backup/in_ab
all=$backup/all
datadir="$HOME/Library/Application Support/AddressBook"
db=`echo "$datadir"/*.abcddb`

exit_ab() {
  echo killing AddressBook
  ps -u `whoami` | grep "Address Book" | grep /Applications | awk '{print $2}'|xargs -n 1 kill -9
}

backup_ab() {
  echo "Backing up address book directory $datadir to backup $backup"
  rm -rf  $backup > /dev/null 2>&1
  mkdir $backup
  ditto "$datadir" "$backup"
}

remove_old() {
  echo extract list of contacts in AB from SQLite
  sqlite3 "$db" "select zuniqueid from zabcdrecord"|cut -d: -f 1|sort > $in_ab
  cd "$datadir"

  cd Images

  # comment out the next two lines if you want to keep full-size originals
  echo removing full-scale images
  rm -f *.jpeg

  echo finding all the images
  ls -1|grep -v '\.jpeg$'|sort > $all

  echo removing images with no associated AB record
  comm -13 $in_ab $all | xargs rm
}

exit_ab
backup_ab
remove_old
